/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef BUS_PROTO_HH
#define BUS_PROTO_HH
#include <utils/err.hh>
#include <string>

namespace err
{
	struct proto: public general
	{
		proto(const std::string& why): general(why) {}
	};

	struct finish {};

};

void step(void);
void run(void);
std::string get_state(void);
void set_state(const std::string&);

namespace woobus { class module; }
woobus::module *current_module(void);
woobus::module *neigbour_module(void);
void set_current_module(woobus::module *);
void set_neighbour_module(woobus::module *);

#endif // BUS_PROTO_HH
