/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef	UTILS_FUNCTOR_HH__
#define UTILS_FUNCTOR_HH__

#include <stdexcept>

#include <utils/shared_ptr.hh>

namespace alt
{
	template <typename RetT, typename Arg1,typename Arg2>
	struct functor_impl
	{ /**< general polimorfic functor interface */
		virtual ~functor_impl() {}
		virtual RetT operator()(Arg1,Arg2) = 0;
	};

	template <typename FunctorT,
		  typename RetT, typename Arg1,typename Arg2>
	struct functor_impl_arb: public functor_impl<RetT, Arg1, Arg2>
	{ /**< special interface version for arbitrary functor */
		functor_impl_arb(FunctorT fun): fun_(fun) {}

		RetT operator()(Arg1 arg1,Arg2 arg2)
		{
			return fun_(arg1,arg2);
		}

		FunctorT fun_; /**< internal copy of the functor */
	};

	template <typename RetT, typename Arg1,typename Arg2>
	struct functor
	{ /**< generalized functor for ndk++ callbacks*/
		typedef functor_impl<RetT, Arg1, Arg2> impl_type;
		typedef shared_ptr< impl_type > invoker_type;

		functor() {}

		template <typename FunctorT>
		functor(FunctorT fun):   /**<  initialize with functor type */
				invoker_(new functor_impl_arb<FunctorT, RetT, Arg1, Arg2>(fun))
		{}

		RetT operator()(Arg1 arg1,Arg2 arg2)
		{ /**< run action */
			if (invoker_.get()) return (*invoker_.get())(arg1,arg2);
			throw std::runtime_error("calling empty functor");
		}

		template <typename FunctorT>
		functor<RetT,Arg1,Arg2>& operator=(const FunctorT& fun)
		{
			invoker_ = new functor_impl_arb<FunctorT, RetT, Arg1,Arg2>(fun);
			return *this;
		}

		invoker_type invoker_;
	};
}

#endif
