(use-translation _wizard_ "alterator-wizard")

;window definitions
caption "ALT Linux Installer"
full_screen "yes"
;width 80
;height 80
;backgroundpixmap "bg-1024x768.png"

;keyword definitions
(declare-keyword number)
(declare-keyword help)

;wizard helper functions
(define pixmap-dir "/usr/lib/alterator/scripts/")

(include "/usr/share/alterator/common/dialog-frame.scm")

;work with help
(define (wizard-with-help?) (global help))
(define (wizard-switch-help)
  (set-global! help (not (wizard-with-help?))))
(define (wizard-help-button-text)
    (if (wizard-with-help?) (_wizard_ "Hide help") (_wizard_ "Show help")))

(define (wizard-make-help-button)
  (id 'help-button
      (button (wizard-help-button-text)
	      (on-click
		(wizard-switch-help)
		(step-list (relative-height (if (wizard-with-help?) 30 90)))
		(help-button text (wizard-help-button-text))
		(help-viewer hidden (not (wizard-with-help?)))))))

;work with steps
(define (wizard-get-steps)
  (define (combine-name x num) (string-append x (number->string num)))
  (define (get-description st)
    (let loop ((cmd (mapper-view (current-mapper) st)))
      (let ((name (cond-cdr (command-arg-ref cmd 'description))))
	(or name
	    (and (eq? (list-ref cmd 2) 'view)
		 (loop (mapper-view (current-mapper) (list-ref cmd 4))))
	    "unknown"))))
  (let loop ((num 0)
	     (result '()))
    (let ((st (global (sure-symbol (combine-name "step" num)))))
      (if st
	(loop (+ num 1) (append result
				(list (cons (get-description st)
					    st))))
	result))))

(define *wizard-steps* (wizard-get-steps)) ;full step-list
(define *wizard-current-step* (global number)); current step name
(define *wizard-current-step-number*
  (list-index (lambda (x) (eq? (cdr x) *wizard-current-step*)) *wizard-steps*))

(define (get-wizard-step num) (cdr (list-ref *wizard-steps* num)))

(define (wizard-next-step) (get-wizard-step (+ *wizard-current-step-number* 1)))
(define (wizard-prev-step) (get-wizard-step (- *wizard-current-step-number* 1)))
(define wizard-last-step? (= (- (length *wizard-steps*) 1) *wizard-current-step-number*))
(define wizard-first-step? (= 0 *wizard-current-step-number*))

;create top line with title
(define (wizard-make-title-line)
  (label (car (list-ref *wizard-steps* *wizard-current-step-number*))
	 font bold-font))

;go previous step button
(define (wizard-make-prev-button)
  (begin-1
    (id 'prev-button
	(if (dlg-frame-global-passing?)
	  (if wizard-first-step?
	    (button (_wizard_ "Cancel") (dlg-frame-prev-attr-enabled) (on-click (end-dialog)))
	    (button (_wizard_ "Prev") (dlg-frame-prev-attr-enabled)
		    (on-click
		      (goto (wizard-prev-step)))))
	  (button (_wizard_ "Prev") (dlg-frame-prev-attr-enabled) (on-click (page 'call on-prev)))))
    (dlg-frame-mark-prev-button)))

;go next step button
(define (wizard-make-next-button)
  (begin-1
    (id 'next-button
	(if (dlg-frame-global-passing?)
	  (if wizard-last-step?
	    (button (_wizard_ "Finish") (dlg-frame-next-attr-enabled) (on-click (end-dialog)))
	    (button (_wizard_ "Next") (dlg-frame-next-attr-enabled)
		    (on-click
		      (and (page 'call on-apply)
			   (goto (wizard-next-step))))))
	  (button (_wizard_ "Next") (dlg-frame-next-attr-enabled) 
		  (on-click
		    (page 'call on-next)))))
    (dlg-frame-mark-next-button)))

;create bottom line with buttons
(define (wizard-make-buttons)
  (hbox margin 2 spacing 1
	(wizard-make-help-button)
	(wizard-make-prev-button)
	(wizard-make-next-button)))

;window with internal page and navigation buttons
(define (wizard-make-page-window)
  (vbox margin 1
    (wizard-make-title-line)
    (dlg-frame-make-page 70 80)
    (wizard-make-buttons)))

(define (file-content filename)
  (or
    (and filename
	 (with-output-to-string
	   (lambda ()
	     (with-input-from-file filename
				   (lambda ()
				     (let loop ((current (read-line)))
				       (and (not (eof-object? current))
					    (write-line current)
					    (loop (read-line)))))))))
    ""))

(define (wizard-help-file filename)
  (define (cut-extension name)
    (substring name 0
	       (or (string-index-right name #\.)
		   (string-length name))))
  (help-file (basename (string-append (cut-extension filename) ".html"))))
  
(define (wizard-step-pixmap num)
  (string-append pixmap-dir
		 (cond ((< num *wizard-current-step-number*) "step_state_configured.png")
		       ((= num *wizard-current-step-number*) "step_state_current.png")
		       (else "step_state_unknown.png"))))

(define (wizard-step-labels)
  (fold (lambda (current result)
		(let ((name (car current))
		      (num (length result)))
		  (append result (list (cons name (wizard-step-pixmap num))))))
	      '()
	      *wizard-steps*))

(define (wizard-make-step-list w h)
  (id 'step-list (listbox 
		  (relative-width w)
		  (relative-height h)
		  (items (wizard-step-labels))
		  current *wizard-current-step-number*
                  (on-select
		    (let ((cur-num (step-list current)))
		      (if (< cur-num *wizard-current-step-number*)
			(goto (get-wizard-step cur-num))
			(step-list current *wizard-current-step-number*)))))))

;window with help and list with available steps
(define (wizard-make-support-window)
    (vbox margin 2 spacing 1 sizepolicy 'fixed
	  (wizard-make-step-list 20 (if (wizard-with-help?) 30 90))
	  (id 'help-viewer
	      (textbox (file-content (wizard-help-file (dlg-frame-real-filename)))
		       hidden (not (wizard-with-help?))
		       (relative-width 20) (relative-height 60) readonly yes))))

;widget description
(hbox
  (wizard-make-support-window)
  (wizard-make-page-window))

