/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <bus/bus.hh>
#include <list>
#include <stdexcept>

namespace
{
	typedef std::list<woobus::module> bus_t;
	static bus_t bus;

	// FIXME: looks like an utility
	template <typename T> struct ptr_eq_p_impl
	{
		ptr_eq_p_impl(const T *ptr): ptr_(ptr) {}

		bool operator()(const T& o) const
		{
			return &o == ptr_;
		}

	private:
		const T *ptr_;
	};

	template <typename T>
	ptr_eq_p_impl<T> ptr_eq_p(const T *ptr)
	{
		return ptr_eq_p_impl<T>(ptr);
	}

	bus_t::iterator find(woobus::module *m)
	{
		return std::find_if(bus.begin(), bus.end(), ptr_eq_p(m));
	}
}

bus_iterator::bus_iterator(woobus::module *m)
	: current_(m)
{
	if(current_ && (find(current_) == bus.end())) current_ = 0;
}

bus_iterator& bus_iterator::operator ++(void)
{
	if(current_)
	{
		bus_t::iterator i = find(current_);
		if((i == bus.end()) || ((++i) == bus.end())) current_ = 0;
		else current_ = &(*i);
	}
	return *this;
}

bus_iterator& bus_iterator::operator --(void)
{
	bus_t::iterator i = find(current_);
	if(i != bus.begin()) current_ = &(*--i);
	else throw std::out_of_range("");
	return *this;
}

bus_iterator modules_begin(void)
{
	if(bus.empty()) return bus_iterator();
	return bus_iterator(&(*bus.begin()));
}

bus_iterator modules_end(void)
{
	return bus_iterator();
}

void modules_insert(const bus_iterator& i, const woobus::module& m)
{
	bus.insert(find(&(*i)), m);
}

void modules_append(const bus_iterator& i, const woobus::module& m)
{
	bus_t::iterator ii = find(&(*i));
	if(ii != bus.end()) ++ii;
	bus.insert(ii, m);
}

void modules_remove(const bus_iterator& i)
{
	bus.erase(find(&(*i)));
}

void stopper(woobus::module& m)
{
	m.stop();
}

void bus_finit(void)
{
	std::for_each(modules_begin(), modules_end(), stopper);
}
