/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <bus/bus.hh>
#include <bus/console.hh>
#include <utils/os.hh>

void start_cmd(std::istream&, std::ostream&, const std::string& point)
{
	if(point.empty()) throw console_error("<point> is missing");

	bus_iterator i = not_modules_end(find_point(point));
	if(i->is_running())
		throw console_error("module is already running");
	try
	{
		i->start();
	}
	catch(const err::sys& x)
	{
		throw console_error(
			std::string("cannot start module: ") + x.why());
	}
}

void stop_cmd(std::istream&, std::ostream&, const std::string& point)
{
	if(point.empty()) throw console_error("<point> is missing");

	bus_iterator i = not_modules_end(find_point(point));
	if(!i->is_running())
		throw console_error("module is not running");
	try
	{
		i->stop();
	}
	catch(const err::sys& x)
	{
		throw console_error(
			std::string("cannot stop module: ") + x.why());
	}
}
