/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <bus/proto.hh>
#include <bus/console.hh>
#include <bus/bus.hh>

namespace
{
	static std::string mod(module *m)
	{
		if(!m) return "(-none-)";
		return m->name();
	}
}

void status_cmd(std::istream&, std::ostream& os, const std::string&)
{
	os	<< "current state:  " << get_state() << "\n"
		<< "current module: " << mod(current_module()) << "\n"
		<< "neigbour module: " << mod(neigbour_module()) << std::endl;
}

void setstate_cmd(std::istream& is, std::ostream& os, const std::string& state)
{
	set_state(state);
	status_cmd(is, os, "");
}

void setcurrent_cmd(std::istream& is, std::ostream& os,
						const std::string& point)
{
	if(point == "<none>") set_current_module(0);
	else set_current_module(&(*not_modules_end(find_point(point))));
	status_cmd(is, os, "");
}

void setneighbour_cmd(std::istream& is, std::ostream& os,
						const std::string& point)
{
	if(point == "<none>") set_neighbour_module(0);
	else set_neighbour_module(&(*not_modules_end(find_point(point))));
	status_cmd(is, os, "");
}
