/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <bus/core.hh>
#include <bus/ctrlc.hh>
#include <utils/os.hh>
#include <utils/fdstream.hh>

std::string woobus::module::read_line(void)
{
	if(!is_running()) start();
	if(ctrlc_pressed())
	{
		ctrlc_clear();
		throw err::ctrlc();
	}
	std::string buffer;
	getline(is(), buffer);
	if (getenv("BUS_DEBUG"))
		std::cout << "received: " << command() << ":" << buffer << std::endl;
	if(ctrlc_pressed())
	{
		ctrlc_clear();
		is().clear();
		throw err::ctrlc();
	}
	
	
	return buffer;
}

void woobus::module::send_line(const std::string& msg)
{
	if(!is_running()) start();
	if(ctrlc_pressed())
	{
		ctrlc_clear();
		throw err::ctrlc();
	}
	os() << msg << std::endl;
	if(ctrlc_pressed())
	{
		ctrlc_clear();
		os().clear();
		throw err::ctrlc();
	}
}
