/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <csignal>

namespace
{
	static unsigned ctrlc_flag = 0;

	static void handler(int)
	{
		ctrlc_flag++;
		if(!ctrlc_flag)		// overflow
			ctrlc_flag--;	// drop one, keep others
	}
};

bool ctrlc_pressed(void)
{
	return ctrlc_flag;
}

void ctrlc_clear(void)
{
	if(ctrlc_flag) --ctrlc_flag;
}

void ctrlc_init(void)
{
	struct sigaction act;
	act.sa_handler = handler;
	sigfillset(&act.sa_mask);
	sigaction(SIGINT, &act, 0);
}
