/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <iostream>
#include <sstream>
#include <command_io.hh>
#include <bus_io.hh>
#include <cache.hh>

command receive(std::istream& is, std::ostream& os)
{
	std::string message;
	os << "vv" << std::endl;
	while(is)
	{
		std::string buf;
		getline(is, buf);
		if(is && buf == "^^") break;
		message += buf + '\n';
	}
	std::istringstream s(message);
	command cmd;
	((std::istream&)s) >> cmd;
	return cmd;
}

void command_down(const command& cmd, std::istream& is, std::ostream& os);

int wait_command_down(std::istream& is, std::ostream& os)
{
	std::cerr << "wait_command_down" << std::endl;
	while(is)
	{
		std::string buf;
		getline(is, buf);
		if(buf == ">>")
		{
			command_down(receive(is, os), is, os);
		}
		else if(buf == "<<")
		{
			os << "<>" << std::endl;
		}
	}
	return 0;
}

void wait_accept(std::istream& is)
{
	while(is)
	{
		std::string buf;
		getline(is, buf);
		if(is && buf == "vv") return;
	}
}

void empty_answer_up(std::istream& is, std::ostream& os)
{
	os << "<<" << std::endl;
	wait_accept(is);
	os << "^^" << std::endl;
}

void send_down(const command& cmd, std::istream& is, std::ostream& os)
{
	os << ">>" << std::endl;
	wait_accept(is);
	os << cmd << "^^" << std::endl;
}

void send_up(const std::string& msg, std::istream& is, std::ostream& os)
{
	os << "<<" << std::endl;
	wait_accept(is);
	os << msg << "^^" << std::endl;
}

void ignore_up(std::istream& is, std::ostream& os)
{
	while(is)
	{
		std::string buf;
		getline(is, buf);
		if(buf == "<<")
		{
			os << "<>" << std::endl;
			return;
		}
	}
}

void ignore_next(int count, std::istream& is, std::ostream& os)
{
	while(is && count)
	{
		std::string buf;
		getline(is, buf);
		if(buf == ">>")
		{
			os << "<>" << std::endl;
			ignore_up(is, os);
			--count;
		}
	}
}

void receive_up_and_cache(const std::string& id,
			std::istream& is, std::ostream& os)
{
	std::string message;
	while(is)
	{
		std::string buf;
		getline(is, buf);
		if(buf == "<<")
		{
			os << "vv" << std::endl;
			while(is)
			{
				std::string buf;
				getline(is, buf);
				if(is && buf == "^^") break;
				message += buf + '\n';
			}
			cache_add(id, message);
			send_up(message, is, os);
			break;
		}
	}
}

void command_down(const command& cmd, std::istream& is, std::ostream& os)
{
	if(cmd.name() == "/ctrl/cache")
	{
		empty_answer_up(is, os);
		if(cmd("action") == "reset")
		{
			cache_reset();
		}
		else if(cmd("action") == "ignore")
		{
			if(cmd.exists("id"))
			{
				ignore_id(cmd("id"));
			}
			else if(cmd.exists("count"))
			{
				ignore_next(::atoi(cmd("count").c_str()),
						is, os);
			}
			else
			{
				ignore_next(1, is, os);
			}
		}
		else if(cmd("action") == "unignore")
		{
			if(cmd.exists("id"))
			{
				unignore_id(cmd("id"));
			}
			else
			{
				unignore_all();
			}
			empty_answer_up(is, os);
		}
	}
	else
	{
		if(ignored_id_p(cmd.name()) || cmd("action") != "read")
		{
			send_down(cmd, is, os);
			ignore_up(is, os);
			if(cmd("action") != "read") cache_remove(cmd.name());
		}
		else
		{
			if(in_cache_p(cmd.name()))
			{
				send_up(cache_get(cmd.name()), is, os);
			}
			else
			{
				send_down(cmd, is, os);
				receive_up_and_cache(cmd.name(), is, os);
			}
		}
	}
}

int main(void)
{
	return wait_command_down(std::cin, std::cout);
}
