/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <glob.h>

#include <chooser.hh>
#include <sstream>
#include <iostream>
#include <command_io.hh>
#include <utils/err.hh>

struct dump_info
{
	void operator()(const matcher& label, const module& m)
	{
		std::cerr << "-------" << std::endl;
		std::cerr << label.as_command();
		std::cerr << "  --> " << m.command() << std::endl;
	}
};

void
dump_commanders(const commanders_db& commanders)
{
	std::for_each(commanders.begin(), commanders.end(),
			unpair(dump_info()));
}


std::string get_filenames(const std::string& pattern)
{
	std::string result;
	glob_t gl;
	if (!glob(pattern.c_str(),
		  GLOB_BRACE|GLOB_NOSORT|GLOB_MARK,NULL,&gl) &&
		gl.gl_pathc)
	for(size_t i=0;i<gl.gl_pathc;i++)
	{
		result += gl.gl_pathv[i];
		result += "\n";
	}
	globfree(&gl);
	return result;
}


int
main(int argc, char *argv[])
{
	
	try
	{
		commanders_db commanders,rcommanders;
		
		const std::string prefix = (argc>=2)?argv[1]:".";
		{
			std::istringstream is(get_filenames(prefix+"/*.adm"));
			init(is, commanders);
		}
		{
			std::istringstream is(get_filenames(prefix+"/*.radm"));
			init(is, rcommanders);
		}

		convert_for_awhile(commanders, rcommanders, std::cin, std::cout);
	}
	catch(err::general& e)
	{
		std::cerr<<"libaltutils general exception:"<<e.why()<<std::endl;
	}
	catch(std::runtime_error& e)
	{
		std::cerr<<"runtime error:"<<e.what()<<std::endl;
	}
	catch(...)
	{
		std::cerr<<"unknown exception\n";
	}
	return 0;
}
