/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <bus_io.hh>

#include <iostream>

static
void wait_accept(std::istream& is, std::ostream& log)
{
	while(is)
	{
		std::string buf;
		getline(is, buf);
		if(is && buf == "vv") return;
		log	<< "-- invalid accept line: \""
			<< buf << "\"" << std::endl;
	}
	log << "-- unexpected eof" << std::endl;
}

void send(const std::string& addr, const std::string& msg,
		std::istream& is, std::ostream& os, std::ostream& log)
{
	log << "-- offering this message to \"" << addr << "\"" << std::endl;
	os << addr << std::endl;
	wait_accept(is, log);
	os << msg << "^^" << std::endl;
	log << "-- message sent" << std::endl;
}

std::string receive(std::istream& is, std::ostream& os, std::ostream& log)
{
	std::string message;
	os << "vv" << std::endl;
	while(is)
	{
		std::string buf;
		getline(is, buf);
		if(is && buf == "^^") return message;
		message += buf + "\n";
		log << buf << std::endl;
	}
	log << "-- unexpected eof" << std::endl;
	return message;
}

