#include <iostream>
#include <vector>

#include <qapplication.h>
#include <libguile.h>

static scm_t_bits application_tag;

SCM qt_dbus_handler;

SCM scm_application_p(SCM application)
{
	return SCM_SMOB_PREDICATE(application_tag, application) ? SCM_BOOL_T : SCM_BOOL_F;
}

SCM scm_make_application(SCM args,SCM dbus_handler)
{
	SCM_ASSERT(scm_pair_p(args),args, SCM_ARG1, "make-application");

	qt_dbus_handler = dbus_handler;

//	std::vector<char *> argv;
//	for(SCM i=args;i!=SCM_EOL;i=SCM_CDR(i))
//		argv.push_back(::strdup(SCM_STRING_CHARS(SCM_CAR(i))));
//	argv.push_back(0);
//	int argc = argv.size();
	int argc = 1;
	char *argv[1] = {"application"};
	SCM_RETURN_NEWSMOB(application_tag, new QApplication(argc,argv));
}

SCM scm_delete_application(SCM a)
{
	SCM_ASSERT(SCM_SMOB_PREDICATE(application_tag, a),a, SCM_ARG1, "delete-application");
	delete (QApplication*)(SCM_SMOB_DATA(a));
	return SCM_UNSPECIFIED;
}

void scm_init_qt_application()
{
	application_tag = scm_make_smob_type("application", 0);
	scm_c_define_gsubr("application?", 1, 0, 0, (SCM (*)())scm_application_p);
	scm_c_define_gsubr("make-application", 2, 0, 0, (SCM (*)())scm_make_application);
	scm_c_define_gsubr("delete-application", 1, 0, 0, (SCM (*)())scm_delete_application);
}
