/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <qtlook.hh>

scm_t_bits widget_tag;

SCM wrap_scm_widget(qt_widget *w)
{
	SCM_RETURN_NEWSMOB(widget_tag, w);
}

SCM scm_widget_p(SCM widget)
{
	return SCM_SMOB_PREDICATE(widget_tag, widget) ? SCM_BOOL_T : SCM_BOOL_F;
}

SCM scm_widget_start(SCM w)
{
	SCM_ASSERT(SCM_SMOB_PREDICATE(widget_tag, w),
		   w, SCM_ARG1, "widget-start");
	qt_dialog *dlg = dynamic_cast<qt_dialog*>((qt_widget *)(SCM_SMOB_DATA(w)));
	if (dlg) dlg->start();
	return SCM_UNSPECIFIED;
}

SCM scm_widget_stop(SCM w)
{
	SCM_ASSERT(SCM_SMOB_PREDICATE(widget_tag, w),
		   w, SCM_ARG1, "widget-stop");
	qt_dialog *dlg = dynamic_cast<qt_dialog*>((qt_widget *)(SCM_SMOB_DATA(w)));
	if (dlg) dlg->stop();
	return SCM_UNSPECIFIED;
}


SCM scm_widget_delete(SCM w)
{
	SCM_ASSERT(SCM_SMOB_PREDICATE(widget_tag, w),
		   w, SCM_ARG1, "delete-widget");
	((qt_widget *)(SCM_SMOB_DATA(w)))->deleteLater(); //order deferred deletion
	return SCM_UNSPECIFIED;
}

SCM scm_widget_set_attr(SCM w, SCM name, SCM value)
{
	SCM_ASSERT(SCM_SMOB_PREDICATE(widget_tag, w),
		   w, SCM_ARG1, "widget-set-attr");
	SCM_ASSERT(SCM_STRINGP(name), name, SCM_ARG2, "widget-set-attr");

	((qt_widget*)(SCM_SMOB_DATA(w)))->set_attr(SCM_STRING_CHARS(name),value);
	return SCM_UNSPECIFIED;
}

SCM scm_widget_set_extra(SCM w, SCM command, SCM arg1, SCM arg2, SCM arg3)
{
	SCM_ASSERT(SCM_SMOB_PREDICATE(widget_tag, w),
		   w, SCM_ARG1, "widget-set-attr");
	SCM_ASSERT(SCM_STRINGP(command), command, SCM_ARG2, "widget-set-attr");
	SCM_ASSERT(SCM_STRINGP(arg1), arg1, SCM_ARG3, "widget-set-attr");
	SCM_ASSERT(SCM_STRINGP(arg2), arg2, SCM_ARG4, "widget-set-attr");

	((qt_widget*)(SCM_SMOB_DATA(w)))->set_extra(SCM_STRING_CHARS(command),
						    SCM_STRING_CHARS(arg1),
						    SCM_STRING_CHARS(arg2),arg3);
	return SCM_UNSPECIFIED;
}

SCM scm_widget_get_attr(SCM w, SCM name)
{
	SCM_ASSERT(SCM_SMOB_PREDICATE(widget_tag, w),
		   w, SCM_ARG1, "widget-get-attr");
	SCM_ASSERT(SCM_STRINGP(name), name, SCM_ARG2, "widget-get-attr");

	return ((qt_widget*)(SCM_SMOB_DATA(w)))->get_attr(SCM_STRING_CHARS(name));
}

SCM scm_widget_get_extra(SCM w, SCM name,SCM arg)
{
	SCM_ASSERT(SCM_SMOB_PREDICATE(widget_tag, w),
		   w, SCM_ARG1, "widget-get-attr");
	SCM_ASSERT(SCM_STRINGP(name), name, SCM_ARG2, "widget-get-attr");

	return  ((qt_widget*)(SCM_SMOB_DATA(w)))->get_extra(SCM_STRING_CHARS(name),
							    arg);
}


bool null_parent(SCM parent)
{
	return (parent == SCM_UNDEFINED) || !SCM_NFALSEP(parent);
}

#define MAKE_WIDGET(name) \
	SCM scm_make_##name(SCM eventholder,SCM parent)\
	{ \
		SCM_ASSERT(SCM_SMOB_PREDICATE(widget_tag, parent) || \
		           null_parent(parent), \
		   	   parent, SCM_ARG2, "widget-set-attr"); \
		\
		return wrap_scm_widget(new qt_##name(eventholder, \
						     null_parent(parent)? \
						     	0: \
							(qt_widget*)SCM_SMOB_DATA(parent))); \
	}

MAKE_WIDGET(button)
MAKE_WIDGET(label)
MAKE_WIDGET(lineedit)
MAKE_WIDGET(textbox)
MAKE_WIDGET(listbox)
MAKE_WIDGET(combobox)
MAKE_WIDGET(tabbox)
MAKE_WIDGET(checkbox)
MAKE_WIDGET(progressbar)
MAKE_WIDGET(vbox)
MAKE_WIDGET(hbox)
MAKE_WIDGET(dialog)

void scm_init_qt_widgets(void)
{
	widget_tag = scm_make_smob_type("widget", 0);

#define DEFINE_MAKE_WIDGET(name) \
	scm_c_define_gsubr("dlg-make-" #name, 1, 1, 0, \
			(SCM (*)())scm_make_##name)

	DEFINE_MAKE_WIDGET(button);
	DEFINE_MAKE_WIDGET(label);
	DEFINE_MAKE_WIDGET(lineedit);
	DEFINE_MAKE_WIDGET(textbox);
	DEFINE_MAKE_WIDGET(combobox);
	DEFINE_MAKE_WIDGET(listbox);
	DEFINE_MAKE_WIDGET(tabbox);
	DEFINE_MAKE_WIDGET(checkbox);
	DEFINE_MAKE_WIDGET(progressbar);
	DEFINE_MAKE_WIDGET(vbox);
	DEFINE_MAKE_WIDGET(hbox);
	DEFINE_MAKE_WIDGET(dialog);

#undef DEFINE_MAKE_WIDGET

	scm_c_define_gsubr("widget?", 1, 0, 0,
			   (SCM (*)())scm_widget_p);
	scm_c_define_gsubr("widget-set-attr", 3, 0, 0,
			   (SCM (*)())scm_widget_set_attr);
	scm_c_define_gsubr("widget-set-extra", 5, 0, 0,
			   (SCM (*)())scm_widget_set_extra);
	scm_c_define_gsubr("widget-get-attr", 2, 0, 0,
			   (SCM (*)())scm_widget_get_attr);
	scm_c_define_gsubr("widget-get-extra", 3, 0, 0,
			   (SCM (*)())scm_widget_get_extra);
	scm_c_define_gsubr("widget-start", 1, 0, 0,
			   (SCM (*)())scm_widget_start);
	scm_c_define_gsubr("widget-stop", 1, 0, 0,
			   (SCM (*)())scm_widget_stop);
	scm_c_define_gsubr("delete-widget", 1, 0, 0,
			   (SCM (*)())scm_widget_delete);
}
