(use-translation _acc_ "alterator-acc")
;window definitions
caption "ALT Linux Control Center"
width 80
height 70
;backgroundpixmap "bg-1024x768.png"

;keyword definitions
(declare-keyword number)
(declare-keyword help)

(define pixmap-dir "/usr/lib/alterator/scripts/")

;load frame
(include-as-is "/usr/share/alterator/common/dialog-frame.scm")

;checks for global wizard parameters
(define (acc-with-help?) (and (global help) (string=? (global help) "yes")))

;work with steps
(define (fetch-acc-hooks)
  (map (lambda (x) (list-ref x 4)) (mapper-view-all (current-mapper) '/acc-hook)))

(define (get-acc-steps)
  (define (get-description st)
    (let loop ((cmd (mapper-view (current-mapper) st)))
      (let ((name (cond-cdr (command-arg-ref cmd 'description))))
	(or name
	    (and (eq? (list-ref cmd 2) 'view)
		 (loop (mapper-view (current-mapper) (list-ref cmd 4))))
	    "unknown"))))
  (sort
    (map
      (lambda (step)
	(cons (get-description step)
	      step))
      (fetch-acc-hooks))
    (lambda (x y)
      (string<? (car x) (car y)))))

(define *acc-steps* (get-acc-steps)) ;full step-list

(define *acc-current-step* (or (global number) (and (pair? *acc-steps*)
						    (cdar *acc-steps*))))

;current step number in list
(define *acc-current-step-number*
  (and (pair? *acc-steps*)
       (list-index (lambda (x) (eq? (cdr x) *acc-current-step*)) *acc-steps*)))

(define (acc-get-step num) (cdr (list-ref *acc-steps*  num)))

(define (acc-step-pixmap num)
  (string-append pixmap-dir
		 (if (and *acc-current-step-number* (= num *acc-current-step-number*))
		   "step_state_current.png"
		   "step_state_unknown.png")))

(define (step-labels)
  (fold (lambda (current result)
		(let ((name (car current))
		      (num (length result)))
		  (append result (list (cons name (acc-step-pixmap num))))))
	      '()
	      *acc-steps*))

(define *acc-under-selection* #f)

(define (acc-process-change status)
  (case status
    ((locked) (run-dialog `(/information message ,(_acc_ "Module is locked")))
	      (acc-process-change 'stay-on))
    ((stay-on) (step-list current *acc-current-step-number*) #t)
    ((need-confirm) (acc-process-change (run-dialog '(/acc-confirm))))
    ((apply-and-go) (if (page 'call on-apply)
		      (acc-process-change 'discard)
		      (acc-process-change 'stay-on)))
    (else ;discard
      (goto (acc-get-step (step-list current))))))

(define (acc-make-step-list w h)
  (id 'step-list (listbox 
		  (relative-width w)
		  (relative-height h)
		  (items (step-labels))
		  (if *acc-current-step-number* (current *acc-current-step-number*))
                  (on-select 
		    (if (not *acc-under-selection*)
		      (begin (set! *acc-under-selection* #t)
			     (acc-process-change (page 'call on-acc-leave))
			     (set! *acc-under-selection* #f)))))))

;widget description
(hbox
  (acc-make-step-list 20 90)
  (dlg-frame-make-frame 70 80))

