;description: dialog's context
;lookout context contains:
; * current goto-frame
; * current stack of globals

(define-module (alterator lookout context)
	       :use-module (srfi srfi-1)
	       :use-module (alterator algo)
	       :use-module (alterator lookout context)
	       :export (lookout-context

			 global
			 set-global!

			 make-globals
			 with-globals
			 extend-globals
			 reset-globals!))

(define lookout-context (make-fluid))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;globals is a list of frames

(define (prepare-globals lst)
  (let loop ((lst lst)
	     (result '()))
    (if (null? lst) result
      (loop (cddr lst)
	    (acons (car lst) (cadr lst) result)))))

(define (make-globals lst)
  (list (prepare-globals lst)))

(define (extend-globals lst)
  (define (cond-append a b) (if b (append a b) a))
  (cond-append (make-globals lst) (cond-cadr (fluid-ref lookout-context))))

(define (reset-globals! lst)
 (let ((current-globals (cond-cadr (fluid-ref lookout-context))))
    (and (pair? current-globals)
	 (set-car! current-globals (prepare-globals lst)))))

(define (global name)
  (let ((current-globals (cond-cadr (fluid-ref lookout-context))))
    (and (pair? current-globals)
	 (call-with-current-continuation
	   (lambda(exit)
	     (for-each (lambda (globals-frame)
			 (let ((result (cond-cdr (assoc name globals-frame))))
			   (and result (exit result))))
	       current-globals)
	       #f)))))

(define (set-global! name value)
  (let ((current-globals (cond-cadr (fluid-ref lookout-context))))
    (and current-globals
	 (set-car! current-globals (alist-set name value (car current-globals))))))

(define-macro (with-globals lst . instructions)
	      `(with-fluids ((lookout-context (list
					       (cond-car (fluid-ref lookout-context))
					       (make-globals ,lst))))
			   ,@instructions))
