;description: functions to change content of some widgets
;goto-in-widget replace content of selected widget
;goto function same as goto-in-widget, but works in some default goto-frame
;goto-frame lives in current lookout context

(define-module (alterator lookout goto)
	       :use-module (alterator algo)
	       :use-module (alterator lookout context)
	       :use-module (alterator lookout uri)
	       :use-module (alterator lookout mapper)
	       :use-module (alterator lookout widgets)
	       :export (goto
			 goto-in-widget
			 goto-frame
			 with-goto-frame))

;pseudo widget to redirect current goto-frame to it's args
(define (goto-frame . widgetlist)
  (let ((pseudo (make-widget pseudo-widget)))
    (list
      'widget
      (make-widget pseudo-widget)
      (lambda (parent)
	(with-fluids ((lookout-context (list parent
					     (extend-globals '()))))
		     (widget-parse-args parent widgetlist)
		     pseudo)))))
	     
;replace content in some widget
(define (goto-in-widget widget url . args)
  (let ((path (lookout-convert-uri (current-mapper) (cons url args))))
    (and path
	 (widget 'delete-subwidgets)
	 (reset-globals! (cdr path))
	 (widget-parse-args widget (load-widgets (car path)))
	 (widget 'show-subwidgets))))

(define (goto url . args)
  (let ((current-goto-frame (or (cond-car (fluid-ref lookout-context))
				(current-dialog))))
    (apply goto-in-widget current-goto-frame url args)))

(define-macro (with-goto-frame frame . instructions)
	      `(with-fluids ((lookout-context (list ,frame
						    (cond-cadr (fluid-ref lookout-context)))))
			    ,@instructions))
