;general frame for standalone configurators
(define *standalone-start-url* (sure-symbol (global 'url)))

(define (get-description st)
  (let loop ((cmd (mapper-view (current-mapper) st)))
    (let ((name (cond-cdr (command-arg-ref cmd 'description))))
      (or name
	  (and (eq? (list-ref cmd 2) 'view)
	       (loop (mapper-view (current-mapper) (list-ref cmd 4))))
	  "unknown"))))

caption (get-description *standalone-start-url*)
width 60
height 70

(include-as-is "/usr/share/alterator/common/dialog-frame.scm")

(on-goto
  (dlg-frame-global-set! (eq? (sure-symbol url) *standalone-start-url*))
  (next-button text (dlg-frame-next-button-text))
  (prev-button text (dlg-frame-prev-button-text)))
  
(dlg-make-frame 100 80 *standalone-start-url*)

