#include <qpushbutton.h>
#include <qlabel.h>

#include <qt_dialog.hh>
#include <pair_ops.hh>

namespace
{
    void del_widget(QWidget *w) { delete w; }
}

qt_dialog::qt_dialog():
    dialog_(),
    layout_(&dialog_)
{}

qt_dialog::~qt_dialog()
{
    std::for_each(widgets_.begin(),widgets_.end(),second(del_widget));
}

void
qt_dialog::add_button(const std::string& id, const std::string& name, long key)
{
    QPushButton *button = new QPushButton(name,&dialog_);
    layout_.addWidget(button);
    
    widgets_[id] = button;
    commands_[id]= key;
    
    //also made QT connection here
}

void
qt_dialog::add_label(const std::string& id,const std::string& name)
{
    QLabel *label = new QLabel(name,&dialog_);
    layout_.addWidget(label);

    widgets_[id] = label;
}

void
qt_dialog::add_edit(const std::string&, const std::string&)
{}

long qt_dialog::run()
{
    dialog_.exec();
    return 0;
}
