;description: per dialog global variables
;globals is a list of frames, each frame is alist

(define-module (alterator lookout globals)
	       :use-module (srfi srfi-1)
	       :use-module (alterator algo)
	       :use-module (alterator lookout context)
	       :export (global
			set-global!

			make-globals
			with-globals
			extend-globals
			reset-globals!))



(define (prepare-globals lst)
  (let loop ((lst lst)
	     (result '()))
    (if (null? lst) result
      (loop (cddr lst)
	    (acons (car lst) (cadr lst) result)))))

(define (make-globals lst)
  (list (prepare-globals lst)))

(define (extend-globals lst)
  (define (cond-append a b) (if b (append a b) a))
  (cond-append (make-globals lst) (from-context 'globals)))

(define (reset-globals! lst)
 (let ((current-globals (from-context 'globals)))
    (and (pair? current-globals)
	 (set-car! current-globals (prepare-globals lst)))))

(define (global name)
  (let ((current-globals (from-context 'globals)))
    (and (pair? current-globals)
	 (call-with-current-continuation
	   (lambda(exit)
	     (for-each (lambda (globals-frame)
			 (let ((result (cond-cdr (assoc name globals-frame))))
			   (and result (exit result))))
	       current-globals)
	       #f)))))

(define (set-global! name value)
  (let ((current-globals (from-context 'globals)))
    (and current-globals
	 (set-car! current-globals (alist-set name value (car current-globals))))))

(define-macro (with-globals globals-lst . instructions)
	      `(with-changed-context 'globals ,globals-lst ,@instructions))


