#!/usr/bin/guile -s
!#
(use-modules (ice-9 pretty-print) (ice-9 debug))

(define datadir "../common/")

(load (string-append datadir "admiral.scm"))

(define *admirals* (load-admiral-filters "/usr/lib/alterator/model"))
(define *rear-admirals* (load-rear-admiral-filters "/usr/lib/alterator/model"))

;(pretty-print (car *admirals*))
;(pretty-print *rear-admirals*)

(define cmd '(/users/test action "new" type "local" passwd1 "123" passwd2 "123" allow_su "yes"))

(define fcmd '(/users action "list"))
(define bcmd-lst '((/local_users/test) (/fake_users/test1)))

;(format #t "answer=~A~%"
;	(admiral-filter-command cmd *admirals*))

;(pretty-print (admiral-filter-command cmd *admirals*))

;for debug 
;1.
;(define *debug-cmd* '((
;		       	(/a action "new")
;		       	(/b action "new" b_field "b")
;		       	(/c action "new")
;		       )
;                      (
;		      	(/d action "new")
;			(/b action "new" b1_field "b1")
;		      )))
;2.
;(define *debug-cmd* '((
;		       	(/a action "new")
;		       	(/b action "new")
;		       )
;                      (
;		      	(/c action "new")
;			(/d action "new")
;		      )))
;3.
;(define *debug-cmd* '((
;		       	(/a action "new")
;		       	(/b action "new")
;		       )
;                     (
;		      	(/b action "new" b_field "b")
;			(/a action "new" a_field "b1")
;		      )))
;4.
;(define *debug-cmd* '((
;		       	(/a action "new")
;		       	(/b action "new" b_field "b")
;		       	(/c action "new")
;		       )
;                      (
;		      	(/d action "new")
;			(/b action "new" b1_field "b1")
;			(/e action "new")
;		      )))
;(format #t "cmd-sets=~A~%" *debug-cmd*)
;(format #t "result=~A~%" (admiral-merge *debug-cmd*))



;;;;;;;;;;;;;;;;;;;;;;; main tests ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(format #t "answer=~A~%"
	(admiral-merge
	  (admiral-filter-command cmd *admirals*)))

;prepare-filters
(define *loaded* (admiral-filter-command
			fcmd
			*rear-admirals*))


;(format #t "prepare-filters=~A~%" *loaded*)

(format #t "processing=~A~%"
	(map
   		(lambda (bcmd)
			(rear-admiral-filter-command
				bcmd
				*loaded*))
   		bcmd-lst))

(rear-admiral-cleanup-filters *loaded*)
