#!/usr/bin/guile -s
!#
(use-modules (ice-9 pretty-print) (ice-9 debug))

(define datadir "../common/")

(load (string-append datadir "admiral.scm"))

(define *admirals* (load-admiral-filters "/usr/lib/alterator/model"))
(define *rear-admirals* (load-rear-admiral-filters "/usr/lib/alterator/model"))

;(pretty-print (car *admirals*))
;(pretty-print *rear-admirals*)

(define cmd '(/users/test action "new" type "local" passwd1 "123" passwd2 "123" allow_su "yes"))

(define fcmd '(/users action "list"))
(define bcmd-lst '((/local_users/test) (/error/fake_users reason "234")))

;cond-error-var1
;(define fcmd '(/users/test action "read"))
;(define bcmd-lst '((/error/local_users/test reason "123")
;                   (/error/fake_users/test reason "234")))


;cond-error-var2
;(define fcmd '(/users/test action "read"))
;(define bcmd-lst '((/error/local_users/test reason "123")
;                   (/fake_users/test uid "123")))

;cond-error-var3
;(define fcmd '(/users/test action "read"))
;(define bcmd-lst '((/error/local_users/test reason "123")))



;(format #t "answer=~A~%"
;	(admiral-filter-command cmd *admirals*))

;(pretty-print (admiral-filter-command cmd *admirals*))

;for debug 
;1.
;(define *debug-cmd* '((
;		       	(/a action "new")
;		       	(/b action "new" b_field "b")
;		       	(/c action "new")
;		       )
;                      (
;		      	(/d action "new")
;			(/b action "new" b1_field "b1")
;		      )))
;2.
;(define *debug-cmd* '((
;		       	(/a action "new")
;		       	(/b action "new")
;		       )
;                      (
;		      	(/c action "new")
;			(/d action "new")
;		      )))
;3.
;(define *debug-cmd* '((
;		       	(/a action "new")
;		       	(/b action "new")
;		       )
;                     (
;		      	(/b action "new" b_field "b")
;			(/a action "new" a_field "b1")
;		      )))
;4.
;(define *debug-cmd* '((
;		       	(/a action "new")
;		       	(/b action "new" b_field "b")
;		       	(/c action "new")
;		       )
;                      (
;		      	(/d action "new")
;			(/b action "new" b1_field "b1")
;			(/e action "new")
;		      )))
;(format #t "cmd-sets=~A~%" *debug-cmd*)
;(format #t "result=~A~%" (admiral-merge *debug-cmd*))


;(define filter (make-rear-admiral-native-filter
;		 "/usr/lib/alterator/model/local_users.radm"))

;(define t-fcmd '(/users action "list"))
;(define t-bcmd '(/local_users/test))

;(format #t "make-filter=~A~%" (car filter))
;(format #t "match=~A~%" (admiral-pattern-match? (caar filter)
;						t-fcmd))

;(define second-filter ((cdar filter) t-fcmd))
;(format #t "secondary-filter=~A~%" (second-filter t-bcmd))



;;;;;;;;;;;;;;;;;;;;;;; main tests ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;

;;;;;;;;;;;;;;FORWARD

;TODO algo:
; if answer before merge is empty, then send command down as-is

(format #t "answer=~S~%"
	(admiral-merge
	  (admiral-filter-command cmd *admirals*)))


;;;;;;;;;;;;BACKWARD

;prepare-filters
(define *loaded* (admiral-filter-command
			fcmd
			*rear-admirals*))


;TODO algo:
; if *loaded* is empty, then send command up as-is

(format #t "prepare-filters=~S~%" *loaded*)

(format #t "pre-answer=~S~%"
	  (map
	    (lambda (bcmd)
	      (rear-admiral-filter-command
		bcmd
		*loaded*))
	    bcmd-lst))

(format #t "answer=~S~%"
	(admiral-merge
	  (map
	    (lambda (bcmd)
	      (rear-admiral-filter-command
		bcmd
		*loaded*))
	    bcmd-lst)))

(format #t "post-answer=~S~%"
      (rear-admiral-drop-errors
	(admiral-merge
	  (map
	    (lambda (bcmd)
	      (rear-admiral-filter-command
		bcmd
		*loaded*))
	    bcmd-lst))))


(rear-admiral-cleanup-filters *loaded*)
