/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <iostream>
#include <chooser.hh>
#include <command_io.hh>

struct add_attr_to_matcher
{
	add_attr_to_matcher(matcher& label): label_(label) {}

	void operator()(const std::string& name, const std::string& value)
	{
		label_(name, value);
	}

private:
	matcher& label_;
};

void init(std::istream& cfg, commanders_db& cmds)
{
	while(cfg)
	{
		std::string cmd;
		getline(cfg, cmd);
		if(!cfg && cmd.empty()) break;
		module m(cmd);
		m.start("init");
		while(m.is())
		{
			command c;
			if(m.is() >> c)
			{
				matcher label;
				label(c.name());
				c.for_each(add_attr_to_matcher(label));
				cmds.push_back(make_pair(label, cmd));
			}
		}
		m.stop();
	}
}
