/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <command_io.hh>

#include <iostream>

std::string
encode(std::string text) // string has been copied on purpose
{
	std::string::size_type pos = 0;
	while((pos = text.find_first_of(":$\n", pos)) != std::string::npos)
		switch(text[pos])
		{
			case ':' : text.replace(pos, 1, "$%"); pos += 2;break;
			case '$' : text.replace(pos, 1, "$$"); pos += 2;break;
			case '\n': text.replace(pos, 1, "$n"); pos += 2;break;
			default: break;
		}
	return text;
}

std::string
decode(std::string text) // string has been copied on purpose
{
	std::string::size_type pos = 0;
	while((pos = text.find('$', pos)) != std::string::npos
						&& pos != text.size() - 1)
		switch(text[pos + 1])
		{
			case '%': text.replace(pos, 2, ":"), ++pos; break;
			case '$': text.replace(pos, 2, "$"), ++pos; break;
			case 'n': text.replace(pos, 2, "\n"), ++pos; break;
			default: break;
		}
	return text;
}

struct out_pair
{
	out_pair(std::ostream& os): os_(os) {}
	void operator()(const std::string& key, const std::string& value)
	{
		os_ << '+' << encode(key) << ':' << encode(value) << '\n';
	}
private:
	std::ostream& os_;
};

std::ostream&
operator<<(std::ostream& os, const command& cmd)
{
	os << '%' << encode(cmd.name()) << '\n';
	cmd.for_each(out_pair(os));
	return os << '#' << std::endl;
}

static void
read_name(std::istream& is, command& cmd)
{
	std::string name;
	getline(is, name);
	cmd.name(decode(name));
}

static void
read_attr(std::istream& is, command& cmd)
{
	std::string buffer;
	getline(is, buffer);

	std::string::size_type pos = buffer.find(':');
	if(pos != std::string::npos)
		cmd.add(decode(buffer.substr(0, pos)), decode(buffer.substr(pos + 1)));
	else
		cmd.add(decode(buffer), "");
}

static void
read_skip(std::istream& is)
{
	while(is && is.get()!='\n');
}


std::istream&
operator>>(std::istream& is, command& cmd)
{
	cmd = command();//first reset command

	while(is)
		switch(is.get())
		{
			case '%': read_name(is, cmd); break;
			case '+': read_attr(is, cmd); break;
			case '#': read_skip(is); return is;
			default:
				break; //ignore strange symbols
		}
	return is;
}
