/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <stdexcept>

#include <context.hh>

context&
context::add(const std::string& key, const std::string& value, policy_t policy)
{
	params_t::iterator i = params_.find(key);
	if(i != params_.end()) i->second = policy(i->second, value);
	else params_.insert(make_pair(key, value));
	return *this;
}

struct add_pair
{
	add_pair(context& c, context::policy_t p): ctx_(c), policy_(p) {}
	void operator()(const context::params_t::value_type& p) const
	{
		ctx_.add(p.first, p.second, policy_);
	}

private:
	context& ctx_;
	context::policy_t policy_;
};

context&
context::add(const context& ctx, policy_t policy)
{
	std::for_each(ctx.params_.begin(), ctx.params_.end(),
						add_pair(*this, policy));
	return *this;
}

const std::string&
context::get(const std::string& key) const
{
	params_t::const_iterator i = params_.find(key);
	if(i != params_.end()) return i->second;
	throw missing();
}

bool
context::exists(const std::string& key) const
{
	return params_.find(key) != params_.end();
}

context&
context::remove(const std::string& key)
{
	return params_.erase(key), *this;
}

struct remove_pair
{
	remove_pair(context& c): ctx_(c) {}
	void operator()(const context::params_t::value_type& p) const
	{
		ctx_.remove(p.first);
	}

private:
	context& ctx_;
};

context&
context::remove(const context& ctx)
{
	std::for_each(ctx.params_.begin(), ctx.params_.end(),
						remove_pair(*this));
	return *this;
}
