;description: general helper functions for admirals and future chooser engine
(define-module (alterator admiral common)

	       :use-module (srfi srfi-1)

	       :use-module (alterator pipe)
	       :use-module (alterator str)
	       :use-module (alterator command)
	       :use-module (alterator compat command)

	       :use-module (alterator admiral pattern)

               :export (admiral-read-script
;			 print-init
			 find-and-eval
			 
			 make-admiral-filter
			 make-adapted-filter

			 admiral-merge 
			 
			 admiral-native-filter?))

;generalized read-script engine
(define (admiral-read-script filename valid-expr)
  (with-input-from-file filename
			(lambda ()
			  (let loop ((expr (read))
				     (result '()))
			    (if (eof-object? expr)
			      result
			      (cond
				((string? expr) (loop (read) result))
				((valid-expr expr) (loop (read) (append result (list expr))))
				(else (error "invalid config expression:" expr))))))))

;generalized print init info engine
;(define (print-init lst)
;  (define (to-old-chooser cmd) ;C++ version of chooser cannot work with symbols ;)
;    (map (lambda (x)
;	   (if (symbol? x) (string-append "^" (sure-string x) "$") x))
;	 cmd))
;  (for-each (lambda (x) (write-command (to-old-chooser (car x)))) lst))

;general find and eval engine
(define (find-and-eval cmd lst match-proc made-proc)
  (let loop ((lst lst))
    (if (null? lst)
      #f
      (let* ((current (car lst))
	     (match-result (match-proc (car current) cmd)))
	(if match-result
	  (made-proc match-result cmd (cdr current))
	  (loop (cdr lst)))))))


;create adapter for filter (external filter)
(define (make-adapted-filter filename func)
  (define (all-strings pattern)
    (map sure-string pattern))
  (define (read-init-data filename)
    (with-input-from-pipe
      `(,filename "init")
      (lambda ()
	(read-command-list))))

  (map (lambda (pattern)
	 (cons (make-admiral-pattern (all-strings pattern))
	       (lambda (ctxt) (func (cdr ctxt) filename))))
       (read-init-data filename)))


;check for internal,native filter
(define (admiral-native-filter? filename)
  (with-input-from-file
    filename
    (lambda()
      (let ((a (read-char))
	    (b (read-char))
	    (c (read-char)))
	(and (char=? a #\")
	     (char=? b #\:)
	     (char=? c #\"))))))

;helper function
(define (join-errors-or-commands cmd1 cmd2)
  (if (error-command? cmd1)
    (join-error-commands cmd1 cmd2)
    (join-commands cmd1 cmd2)))

;merge series of collected commands into one list
(define (admiral-merge cmdlist)
  (if (not (pair? cmdlist))
    '()
    ;try to join all cmdsets with first
    (let ext-loop ((current (cdr cmdlist))
		   (result (car cmdlist)))
;      (format #t "big-loop,current=~A~%==,result=~A~%" current result)
      (if (null? current) result
	;try to join all commands in current cmdset to current result
	(ext-loop
	  (cdr current);go to the next cmdset
	  (let int-loop ((result result) ;result
			 (to-join '()) ;collection of commands to join
			 (lst (car current))) ;current command list 
;	    (format #t "mini-loop,result=~A~%==,lst=~A~%==,to-join=~A~%" result lst to-join)
	    (if (null? lst) (append result to-join)
	      (let ((number
		      (list-index (lambda(x)
				    (eq? (command-name x) (command-name (car lst))))
				  result)))
;		(format #t "elt=~A,number=~A~%" (car lst) number)
		(if number
		  ;try to join cmds
		    (int-loop
		      (append (list-head result number)
			      to-join
			      (list (join-errors-or-commands (car lst)
						   (list-ref result number)))
			      (list-tail result (+ number 1)))
		      '()
		      (cdr lst))
		    ;append cmd to join-list
		    (int-loop
		      result
		      (append to-join (list (car lst)))
		      (cdr lst)))))))))))

