;description: pattern to explore matching of woobus commands

(define-module (alterator admiral pattern)
	       :use-module (ice-9 regex)
	       :use-module (srfi srfi-2)

	       :use-module (alterator str)
	       :use-module (alterator command)
               :export (make-admiral-pattern
	       		admiral-pattern-subexpr
			admiral-pattern-match?))

(define (make-admiral-pattern-item obj)
  (cond
    ((symbol? obj) (symbol->string obj))
    ((string? obj) (make-regexp obj regexp/extended))
    (else (error "unknown element type in command pattern description" obj))))

;there is a little optimization here: symbol equals "^symbol$" regular expression
(define (make-admiral-pattern cmd) (map make-admiral-pattern-item cmd))

;match one items
(define (admiral-pattern-item-match item line)
  (cond ((regexp? item) (regexp-exec item line))
	((string? item) (and (string=? item line) item))
	(else #f)))

;find pair name-option that matches to pattern
(define (find-arg-match pat-name pat-value cmd)
  (command-find-if
    (lambda (cmd-name cmd-value)
      (let ((name-match (admiral-pattern-item-match pat-name (sure-string cmd-name)))
	    (value-match  (admiral-pattern-item-match pat-value (sure-string cmd-value))))
      (and name-match value-match (list name-match value-match))))
    cmd))

;find all matches for patterns
(define (find-pat-match pattern cmd)
  (call-with-current-continuation
    (lambda (exit)
      (command-fold
	(lambda (pat-name pat-value result)
	  (define founded-arg (find-arg-match pat-name pat-value cmd))
	  (if founded-arg
	    (append result founded-arg)
	    (exit #f)))
	'()
	pattern))))

;are command match to this pattern
(define (admiral-pattern-match? pattern cmd)
  (and-let* ((name-match (admiral-pattern-item-match (car pattern) (sure-string (command-name cmd))))
	     (arg-match (find-pat-match pattern cmd)))
	      (cons name-match arg-match)))

;walk throw structure and find appropriate subexpression by number
(define (admiral-pattern-subexpr ctxt num)
  (let loop ((ctxt ctxt)
	     (num num))
    (if (null? ctxt)
      ""
      (let ((current (car ctxt)))
	(if (vector? current)
	  (let ((num-subexpr (- (vector-length current) 2))); number of subexpressions
	    (if (> (+ 1 num) num-subexpr)
	      (loop (cdr ctxt) (- num num-subexpr));go to other expression with decreased number
	      (regexp-substitute #f current (+ 1 num))))
	  (loop (cdr ctxt) num))))))

