;description: some usefull algorithms, that I cannot find in srfi's
(define-module (alterator algo)
	       :use-module (srfi srfi-1)
	       :export (cond-car
			 cond-cadr
			 cond-cdr
			 for-range
			 with-current-object
			 sure-symbol
			 begin-1
			 
			 list-extract
			 append-not-empty
			 
			 letrec*
			 alist-set))

(define (cond-car key) (and (pair? key) (car key)))
(define (cond-cadr key) (and (pair? key) (pair? (cdr key)) (cadr key)))
(define (cond-cdr key) (and (pair? key) (cdr key)))

(define (for-range proc range)
  (define (process-range proc start stop)
    (let loop ((start start)
	       (stop stop))
      (and (<= start stop)
	   (begin (proc start)
		  (loop (+ 1 start) stop)))))
  (let loop ((lst range))
    (and (not (null? lst))
	 (let ((item (car lst)))
	   (if (pair? item)
	     (process-range proc 
			    (car item)
			    (cdr item))
	     (proc item))
	   (loop (cdr lst))))))

(define (with-current-object set-func! get-func object thunk)
  (let ((saved-object #f))
    (dynamic-wind
      (lambda()
	(set! saved-object (get-func))
	(set-func! object))
      thunk
      (lambda()
	(set-func! saved-object)))))

(define (sure-symbol x)
  (cond
    ((symbol? x) x)
    ((macro? x) (macro-name x))
    ((string? x) (string->symbol x))
    (else "sure-symbol unsupported type for conversion" x)))

;as a begin, but return result of 1st expression
(define-macro (begin-1  . expressions)
	      (let ((result (gensym)))
		`(let ((,result ,(car expressions)))
		   (begin
		     ,@(cdr expressions)
		     ,result))))

(define (list-extract lst pred)
  (let loop ((lst lst)
	     (matched '())
	     (other '()))
    (if (null? lst)
      (cons matched other)
      (let ((item (car lst)))
	(if (pred item)
	  (loop (cdr lst)
		(append matched (list item))
		other)
	  (loop (cdr lst)
		matched
		(append other (list item))))))))

(define (append-not-empty lst1 lst2)
  (or
    (and (pair? lst2) (append lst1 lst2))
    lst1))

(define-macro (letrec* variables . instructions)
  `(let
     ,(map (lambda (x) `(,(car x) #f))
	     variables)
     ,@(append (map (lambda (x) `(set! ,@x))
		    variables)
	       instructions)))

(define (alist-set name value alist)
  (let ((res (assq name alist)))
    (if res
      (acons name value (alist-delete name alist))
      (acons name value alist))))

