;description: woobus module to log all bus messages to file, and replay log as a pseudo interface

(define-module (alterator bridge-book)
	       :use-module (alterator str)
	       :use-module (alterator command)
	       :export (bridge-book-log-forward
			 bridge-book-log-backward
			 bridge-book-write-timestamp

			 bridge-book-record
			 bridge-book-play

			 bridge-book))

(define (bridge-book-play filename writer)
  (call-with-input-file
    filename
    (lambda (logfile)
      (let read-loop ((cmd (read logfile)))
	(or (eof-object? cmd)
	    (begin (writer cmd)
		   (read-loop (read logfile))))))))

(define (bridge-book-log cmds write-empty write-cmd)
	(if (null? cmds)
	  (write-empty)
	  (for-each (lambda (x) (write-cmd x)) cmds)))

;todo: also duplicate command to bus
(define (bridge-book-log-forward logfile cmdlist)
  (define (log-command cmd) (write cmd logfile) (newline logfile))
  (define (log-empty) (display ";question: empty" logfile) (newline logfile))
  (bridge-book-log cmdlist log-empty log-command)
  (force-output logfile)
  cmdlist)

(define (bridge-book-log-backward logfile cmdlist)
  (define (log-command cmd) (display (format #f ";answer: ~S~%" cmd) logfile))
  (define (log-empty) (display ";answer: empty" logfile) (newline logfile))
  (bridge-book-log cmdlist log-empty log-command)
  (force-output logfile)
  cmdlist)

(define (bridge-book-write-timestamp logfile)
  (display (format #f ";log started at ~A~%"
		   (strftime "%c"
			     (localtime (current-time))))
	   logfile))

(define (bridge-book filename)
  (define (back-log logfile cmd-pair)
    (let ((first (car cmd-pair))
	  (cmds (cdr cmd-pair)))
      (cons first
	    (bridge-book-log-backward logfile
				      cmds))))
  (let ((logfile (open-file filename "w")))
    (bridge-book-write-timestamp logfile)
    (lambda (cmd-pair next)
      (let ((first (car cmd-pair))
	    (cmds (cdr cmd-pair)))
	(back-log
	  logfile
	  (next (cons first
		      (bridge-book-log-forward logfile cmds))))))))


