(define-module (alterator gettext)
	       :export (use-translation
			 i18n:tr
			 bind-textdomain-codeset
			 dgettext))

(dynamic-call "scm_init_gettext"
	      (dynamic-link "libguile-gettext.so"))

(define-macro (use-translation prefix textdomain)
	      `(begin
		 (bind-textdomain-codeset ,textdomain "UTF-8")
		 (define (,prefix str)
		   (dgettext ,textdomain str))))

(define (i18n:tr text textdomain)
  (bind-textdomain-codeset textdomain "UTF-8")
  (dgettext  textdomain text))

