(define-module (alterator help)
	       :use-module (srfi srfi-1)
	       :use-module (alterator str)
	       :export (help-file-content))

(define help-path "/usr/share/alterator/help")

(define (extract-lang locale)
  (substring locale
	     0
	     (or (string-index locale #\_) (string-length locale))))

(define (find-help-file helpfile lst)
  (find (lambda (path)
	  (access? path R_OK))
	(map (lambda (item)
	       (string-append help-path "/" item "/" helpfile))
	     lst)))

(define (try-language helpfile)
  (let ((possible (getenv "LANGUAGE")))
    (and possible
	 (find-help-file helpfile
	   (map extract-lang
		(string-splitting possible #\:))))))

(define (try-variable variable helpfile)
  (let ((possible (getenv variable)))
    (and possible
	 (find-help-file helpfile
			 (list (extract-lang possible))))))

(define (help-file-name helpfile)
  (or (try-language helpfile)
      (try-variable "LC_ALL" helpfile)
      (try-variable "LC_MESSAGES" helpfile)
      (try-variable "LANG" helpfile)))

(define (help-file-content filename)
  (let ((real-filename (help-file-name filename)))
    (or (and real-filename
	     (call-with-input-file
	       real-filename
	       (lambda (input)
		      (read-fold
			(lambda (x y)
			  (string-append y (string #\newline) x))
			""
			input))))
	"")))

