;description: set of tools to create local enviroment for evaluated code
(define-module (alterator sandbox)
	       :use-module (alterator algo)
	       :export (sandbox-transform-definitions
			 sandbox-extract-definitions
			 read-file))

;transform sequence:
; (define a ...
; (define b ...
;into:
; (letrec*  ( (a ...) (b ... )) ...
(define (definition->pair item)
  (let ((name (cadr item))
	(value (cddr item)))
    (if (pair? name)
      (let ((func-name (car name))
	    (func-vars (cdr name)))
      `(,func-name (lambda ,func-vars ,@value)))
      `(,name ,@value))))

(define (sandbox-transform-definitions deflist instructions)
  `(letrec* ,(map definition->pair deflist) ,@instructions))

;split readed extressions into definitions and other instructions
(define (sandbox-extract-definitions lst)
  (define (definition? item)
    (and (pair? item)
	 (eq? (car item) 'define)))
  (list-extract lst definition?))

;read all s-expressions in file and return all-of-them in linked list
(define (read-file filename)
  (call-with-input-file
    filename
    (lambda(input)
      (let loop ((item (read input))
		 (result '()))
	(if (eof-object? item)
	  result
	  (loop (read input) (append result (list item))))))))

;not exported yet: for future use
(define *sandbox-dangerous* '(with-input-from-file
			       with-output-to-file
			       call-with-input-file
			       call-with-output-file))

(define (sandbox-prepend-dangerous lst)
  (append (map (lambda (x)
		 `(define ,x #f))
	       *sandbox-dangerous*)
	  lst))

