;description: tools to made function compositions (connection between woobus modules)

(define-module (alterator telegraph)
	       :export (make-telegraph
			 set-forward-hook!
			 set-backward-hook!
			 run-telegraph))

(define-macro (make-telegraph . args)
  `(list 
    #f 
    #f
    ,@(map (lambda (x) `(cons ',x ,x)) args))) ;functions to compose

(define (set-forward-hook! telegraph hook)
  (set-car! telegraph hook))

(define (set-backward-hook! telegraph hook)
  (set-car! (cdr telegraph) hook))

(define (get-forward-hook telegraph)
  (car telegraph))

(define (get-backward-hook telegraph)
  (cadr telegraph))

(define (get-functions telegraph)
  (cddr telegraph))

(define (sure-n-run proc name value)
  (and (procedure? proc) (proc name value)))

(define (run-telegraph cmd telegraph)
  (let* ((lst (get-functions telegraph))
	 (forward-hook (get-forward-hook telegraph))
	 (backward-hook (get-backward-hook telegraph)))
    (if (null? lst)
      cmd
      (begin (sure-n-run forward-hook (caar lst) cmd)
	     (let ((call-result ((cdar lst)
				 cmd
				 (lambda (cmd)
				   (run-telegraph cmd
						  (cons*
						    forward-hook
						    backward-hook
						    (cdr lst)))))))
	       (sure-n-run backward-hook (caar lst) call-result)
	       call-result)))))

