#include <string.h>
#include <glob.h>
#include <libguile.h>

SCM scm_glob(SCM pattern)
{
	SCM lst = SCM_EOL;
	glob_t gl;
	size_t i;

	SCM_ASSERT(SCM_STRINGP(pattern), pattern, SCM_ARG1, "glob");

	if (!glob(SCM_STRING_CHARS(pattern),
				GLOB_BRACE|GLOB_NOSORT|GLOB_MARK,NULL,&gl) &&
			gl.gl_pathc)
		for(i=0;i<gl.gl_pathc;i++)
		{
			const char *item = gl.gl_pathv[i];
			lst = scm_cons (scm_mem2string(item, strlen (item)), lst);
		}
	globfree(&gl);

	return lst;
}

void scm_init_glob(void)
{
	scm_c_define_gsubr("glob", 1, 0, 0,(SCM (*)())scm_glob);
}

