#include <qtlook.hh>

SCM bool2scm (int x) { return SCM_BOOL(x); }
int scm2bool (SCM obj) { return (SCM_FALSEP (obj)) ? 0 : 1; }

SCM str2scm(const char *str) { return scm_mem2string(str?str:"",str?strlen(str):0); }
const char *scm2str(SCM obj) { return SCM_STRING_CHARS(obj); }

SCM num2scm(int num) { return scm_int2num(num); }
int scm2num (SCM obj) { return scm_num2int(obj, SCM_ARG1, "scm2int"); }

SCM symbol2scm(const char *str) { return scm_str2symbol(str); }
const char *scm2symbol(SCM obj) { return SCM_SYMBOL_CHARS(obj); }
