#ifndef ALT_UTILS_PIPE_HH__
#define ALT_UTILS_PIPE_HH__

#include <ios>
#include <cstdio>
#include <string>

#include <utils/err.hh>

namespace alt
{
	/**
	 * simple wrapper around popen library call
	 * @todo: rewrite using fork/exec
	 */
	class pipe
	{
	public:
		pipe(const std::string& cmd, std::ios_base::openmode mode = std::ios_base::in, const std::string& root=""):
				f_(0)
		{
			if (!root.empty())
			    std::cout<<"pipe with chroot not implemented yet\n";
			f_ = ::popen(cmd.c_str(), (mode == std::ios_base::in) ? "r" : "w");
			if (!f_) throw err::sys();
		}
		~pipe()
		{
			if (f_) ::pclose(f_);
		}
		int fd()
		{
			return ::fileno(f_);
		}
	private:
		FILE *f_;
	};
}

#endif
