/*
*  ALTerator - ALT Linux configuration project
*
*  Copyright (c) 2003 ALT Linux Ltd.
*  Copyright (c) 2003 Alexey Voinov
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
*  USA.
*/
#ifndef ALT_UTILS_PSTREAM_HH__
#define ALT_UTILS_PSTREAM_HH__

#include <iostream>
#include <ext/stdio_filebuf.h>

#include <utils/pipe.hh>

namespace alt
{
	//forward definitions
	template <typename charT, typename Traits = std::char_traits<charT> >
	class basic_ipstream;

	template <typename charT, typename Traits = std::char_traits<charT> >
	class basic_opstream;

	template <typename charT, typename Traits = std::char_traits<charT> >
	class basic_pstream;

	//default definitions
	typedef basic_ipstream<char>	ipstream;
	typedef basic_opstream<char>	opstream;
	typedef basic_pstream<char>	pstream;


	/**
	 * input pipe stream
	 */
	template <typename charT, typename Traits>
	class basic_ipstream: public std::basic_istream<charT, Traits>
	{
		typedef charT	char_type;
		typedef Traits	traits_type;
		typedef typename traits_type::int_type	int_type;
		typedef typename traits_type::pos_type	pos_type;
		typedef typename traits_type::off_type	off_type;

		typedef __gnu_cxx::stdio_filebuf<char_type, traits_type> pipebuf_type;
		typedef std::basic_istream<char_type, traits_type> istream_type;
	public:
		basic_ipstream(const std::string cmd,const std::string& root=""):
				istream_type(NULL),
				pipe_(cmd, std::ios_base::in,root),
				pipebuf_(pipe_.fd(), std::ios_base::in, false, BUFSIZ)
		{
			this->init(&pipebuf_);
		}
	private:
		pipe	pipe_; /**< pipe to the subprocess */
		pipebuf_type	pipebuf_; /**< internal read buffer */
	};

	/**
	 * output pipe stream
	 */
	template <typename charT, typename Traits>
	class basic_opstream: public std::basic_ostream<charT, Traits>
	{
		typedef charT	char_type;
		typedef Traits	traits_type;
		typedef typename traits_type::int_type	int_type;
		typedef typename traits_type::pos_type	pos_type;
		typedef typename traits_type::off_type	off_type;

		typedef __gnu_cxx::stdio_filebuf<char_type, traits_type> pipebuf_type;
		typedef std::basic_ostream<char_type, traits_type> ostream_type;
	public:
		basic_opstream(const std::string cmd,const std::string& root=""):
				ostream_type(NULL),
				pipe_(cmd, std::ios_base::out,root),
				pipebuf_(pipe_.fd(), std::ios_base::out, false, BUFSIZ)
		{
			this->init(&pipebuf_);
		}
	private:
		pipe	pipe_; /**< pipe to the subprocess */
		pipebuf_type	pipebuf_; /**< internal read buffer */
	};

	/**
	 * input/output pipe stream
	 */
	template <typename charT, typename Traits>
	class basic_pstream: public std::basic_iostream<charT, Traits>
	{
	public:
		typedef charT	char_type;
		typedef Traits	traits_type;
		typedef typename traits_type::int_type	int_type;
		typedef typename traits_type::pos_type	pos_type;
		typedef typename traits_type::off_type	off_type;

		typedef __gnu_cxx::stdio_filebuf<char_type, traits_type> pipebuf_type;
		typedef std::basic_iostream<char_type, traits_type> iostream_type;
	public:
		basic_pstream(const std::string cmd, std::ios_base::openmode mode):
				iostream_type(NULL),
				pipe_(cmd, mode),
				pipebuf_(pipe_.fd(), mode, false, BUFSIZ)
		{
			this->init(&pipebuf_);
		}
	private:
		pipe	pipe_; /**< pipe to the subprocess */
		pipebuf_type	pipebuf_; /**< internal read buffer */
	};
}

#endif // ALT_UTILS_PSTREAM_HH__
