#include <bufferio.hh>

class nistream
{
	buffer buf_;

public:
	nistream(int fd): buf_(fd) {}

	char get_char(void);
	int get_int(void);
	std::string get_string(char delim = '\n');

	bool eof(void) const { return buf_.eof(); }
};

inline nistream&
operator >> (nistream& is, char& c)
{
	c = is.get_char();
	return is;
}

inline nistream&
operator >> (nistream& is, int& n)
{
	n = is.get_int();
	return is;
}

inline nistream&
operator >> (nistream& is, std::string& str)
{
	str = is.get_string();
	return is;
}

class nostream
{
	obuffer buf_;

public:
	nostream(int fd): buf_(fd) {}

	void put_char(char c);
	void put_string(const std::string& str);
	void flush(void);
};

inline nostream&
operator << (nostream& os, char c)
{
	os.put_char(c);
	return os;
}

inline nostream&
operator << (nostream& os, const std::string& str)
{
	os.put_string(str);
	return os;
}
