;simple implemenation of string-for-each from srfi-13
;will be removed in the future
(define (string-for-each proc str)
  (let loop ((start 0)
	     (end (string-length str)))
    (if (< start end) (begin (proc (string-ref str start))
			     (loop (+ start 1) end)))))

;simple check that object is valid command:
; this is a list and number of elements is odd
(define (command? obj)
  (and (list? obj) (odd? (length obj))))

;return command's name
(define (command-name obj) (car obj))

;function for processing all command's options
;calls procedure with to args option's name and option's value
(define (command-for-each proc obj)
  (let loop ((options (cdr obj)))
	(if (not (null? options))
	  (begin (proc (car options) (cadr options))
		 (loop (cddr options))))))

;made quote transform for the single character
(define (char-quote ch)
  (case ch
    ((#\:) (write-char #\$) (write-char #\%))
    ((#\$) (write-char #\$) (write-char #\$))
    ((#\newline) (write-char #\$) (write-char #\n))
    (else (write-char ch))))

;made quote transform for the string
(define (string-quote str)
;  (with-output-to-string	;for guile
  (with-output-to-string ""	;for gambit
    (lambda () (string-for-each char-quote str))))

;transform symbol to string if we need it
(define (sure-string obj)
  (if (symbol? obj) (symbol->string obj) obj))

;output using old format for the (name,value) option pair
(define (arg->old-format name value)
  (display #\+)
  (display (string-quote (sure-string name)))
  (display #\:)
  (display (string-quote (sure-string value)))
  (newline))

;ouput using old format for the
(define (name->old-format name)
  (display #\%)
  (display (sure-string name))
  (newline))

(define (command->old-format cmd)
  (name->old-format (command-name cmd))
  (command-for-each arg->old-format cmd)
  (display #\#)
  (newline))

;some demo output
(define cmd '(/users/inger action "write" uid "100" gid "200"))
(display "new format:")
(newline)
(write cmd)
(newline)
(display "old format:")
(newline)
(command->old-format cmd)

