;string-index implemantation for gambit
(define (string-index str ch)
  (let loop ((start 0)
	(end (string-length str)))
    (cond ((>= start end) #f)
	  ((char=? (string-ref str start) ch) start)
	  (else (loop (+ 1 start) end)))))

;transform symbol to string if we need it
(define (sure-string obj)
  (if (symbol? obj) (symbol->string obj) obj))

;made quote transform for the single character
(define (char-quote ch)
  (case ch
    ((#\:) "$%")
    ((#\$) "$$")
    ((#\newline) "$n")
    (else (string ch))))

;made reverse transform for char after escape symbol
(define (char-unquote ch)
  (case ch
    ((#\%) ":")
    ((#\$) "$")
    ((#\n) (string #\newline))
    (else (string ch))))

;made quote transform for the string
(define (string-quote str)
  (let loop ((result "")
	     (start 0)
	     (end (string-length str)))
    (if (>= start end)
      result
      (loop (string-append result (char-quote (string-ref str start)))
	    (+ 1 start)
	    end))))

;made reverse transform for the string
(define (string-unquote str)
  (let loop ((result "")
	     (start 0)
	     (end (string-length str)))
    (if (>= start end)
      result
      (if (and (char=? (string-ref str start) #\$)
	       (< (+ 1 start) end))
	(loop (string-append result
			     (char-unquote (string-ref str (+ 1 start))))
	      (+ 2 start)
	      end)
	(loop (string-append result
			     (string (string-ref str start)))
	      (+ 1 start)
	      end)))))
  

;output using old format for the (name,value) option pair
(define (write-command-arg name value)
  (display #\+)
  (display (string-quote (sure-string name)))
  (display #\:)
  (display (string-quote (sure-string value)))
  (newline))

;ouput using old format for the command name
(define (write-command-name name)
  (display #\%)
  (display (sure-string name))
  (newline))

;ouput command to current-output-port in the old format
(define (write-command cmd)
  (write-command-name (command-name cmd))
  (command-for-each write-command-arg cmd)
  (display #\#)
  (newline))

(define (string->command-arg str)
  (let ((separator (string-index str #\:)))
    (or separator 
	(error "unable to find ':' separator in option"))
    (list (string->symbol 
	    (string-unquote (substring str 0 separator)))
	  (string-unquote (substring str (+ 1 separator) (string-length str))))))
 
;create command-name from string
(define (string->command-name str)
  (string->symbol (string-unquote str)))

;read command from current-input-port
;TODO: parse args and unquote strings
(define (read-command)
      (let loop ((cmd '())
		 (line (read-line)))
		 (if (eof-object? line)
		   cmd
		   (case (string-ref line 0)
		     ((#\%) (loop (if (null? cmd) 
				    (list (string->command-name
					    (substring line 1 (string-length line)))) 
				    cmd)
				  (read-line)))
		     ((#\+) (if (null? cmd) (error "options without command name")
				   (loop (append 
					   cmd
					   (string->command-arg
					     (substring line 1 (string-length line))))
					 (read-line))))
		     ((#\#) cmd)
		     (else (error "unknown line prefix"))))))
