;simple check that object is valid command: this is a list and number of elements is odd
(define (command? obj)
  (and (list? obj) (odd? (length obj))))

;name of the command
(define (command-name obj) (car obj))

;function for processing all command's options
;calls procedure with to args option's name and option's value
(define (command-for-each proc obj)
  (let loop ((options (cdr obj)))
	(if (not (null? options))
	  (begin (proc (car options) (cadr options))
		 (loop (cddr options))))))

;query for some option
(define (command-arg-ref cmd argname)
  (call-with-current-continuation
    (lambda (exit)
      (command-for-each 
	(lambda (name value)
	  (and (eq? name argname) (exit (cons name value))))
	cmd)
      #f)))
