(use-modules (ice-9 regex))

(load "command.scm")

(define (make-command-pattern-item obj)
  (cond
    ((symbol? obj) (symbol->string obj))
    ((string? obj) (make-regexp obj regexp/extended))
    (else (error "unknown element type in command pattern description" obj))))

;there is a little optimization here: symbol equals "^symbol$" regular expression
(define (make-command-pattern cmd) (map make-command-pattern-item cmd))

;match one items
;TODO: return empty list or list of founded substrings
(define (command-pattern-item-match item line)
  (cond ((regexp? item) (regexp-exec item line))
	((string? item) (string=? item line))
	(else #f)))

;TODO: return empty list or list of founded subsring for the founded arg
; use for-each with call/cc here (exit on first match)
(define (find-arg-match pat-name pat-value cmd)
  (command-find-if
    (lambda (cmd-name cmd-value)
      (and (command-pattern-item-match pat-name (sure-string cmd-name))
	  (command-pattern-item-match pat-value (sure-string cmd-value))))
    cmd))

;TODO: collect all founded patterns and return list of it, otherwise return empty list
;use for-each and call/cc here (exit on first mismatch)
(define (find-pat-mismatch pattern cmd)
  (command-find-if
    (lambda(pat-name pat-value)
      (not (find-arg-match pat-name pat-value cmd)))
    pattern))

;are command match to this pattern
;TODO: return list of founded subpatterns, otherwise empty list
(define (command-pattern-match pattern cmd)
  (and (command-pattern-item-match (car pattern) (sure-string (command-name cmd)))
       (not (find-pat-mismatch pattern cmd))))
