#ifndef DIALOG_HH
#define DIALOG_HH

#include <string>
#include <map>

class widget
{
	std::map<std::string, long> events_;

public:
	virtual ~widget(void);

	virtual widget& set_attr(const std::string&, const std::string&) = 0;
	virtual std::string get_attr(const std::string& name) = 0;
	virtual widget& insert(widget *) =  0;

	virtual widget& set_event(const std::string&, long);
	virtual long get_event(const std::string&);
};

struct dialog: public widget
{
	virtual ~dialog(void);

	virtual widget *make_button(void) = 0;
	virtual widget *make_label(void) = 0;
	virtual widget *make_textbox(void) = 0;
	virtual widget *make_listbox(void) = 0;
	virtual widget *make_vbox(void) = 0;
	virtual widget *make_hbox(void) = 0;

	virtual void name_it(const std::string&, widget *) = 0;
	virtual widget *who_is_it(const std::string&) const = 0;

	virtual long run(void) = 0;
};

#endif // DIALOG_HH
