#ifndef DIALOG_QT_HH
#define DIALOG_QT_HH

#include <dialog-new.hh>
#include <qmainwindow.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <list>
#include <map>

class qt_dialog: public dialog
{
public:
	qt_dialog(QWidget *);
	~qt_dialog(void);

	virtual widget * make_button(void);
	virtual widget * make_label(void);
	virtual widget * make_textbox(void);
	virtual widget * make_listbox(void);
	virtual widget * make_vbox(void);
	virtual widget * make_hbox(void);

	virtual long run(void);

	virtual widget& set_attr(const std::string&, const std::string&);
	virtual std::string get_attr(const std::string& name);
	virtual widget& insert(widget *);

	virtual void name_it(const std::string&, widget*);
	virtual widget * who_is_it(const std::string&) const;

private:
	widget *remember_pointer(widget *);

	QWidget *wnd_;
	QWidget *top_;
	std::list<widget *> ptrs_;
	std::map<std::string, widget *> names_;
};

class qt_widget: public QObject, public widget
{
	Q_OBJECT
public:
	virtual QWidget *get_widget(void) const = 0;
	virtual widget& insert(widget *);

public slots:
	void on_click(void);
	void on_change(const QString&);
	void on_return(void);
	void on_select(void);
};

class qt_button: public qt_widget
{
	QPushButton *wnd;

public:
	qt_button(QWidget *);

	virtual widget& set_attr(const std::string&, const std::string&);
	virtual std::string get_attr(const std::string& name);
	virtual QWidget *get_widget(void) const;
};

class qt_label: public qt_widget
{
	QLabel *wnd;

public:
	qt_label(QWidget *);

	virtual widget& set_attr(const std::string&, const std::string&);
	virtual std::string get_attr(const std::string& name);
	virtual QWidget *get_widget(void) const;
};

class qt_textbox: public qt_widget
{
	QLineEdit *wnd;

public:
	qt_textbox(QWidget *);

	virtual widget& set_attr(const std::string&, const std::string&);
	virtual std::string get_attr(const std::string& name);
	virtual QWidget *get_widget(void) const;
};

class qt_listbox: public qt_widget
{
	QListBox *wnd;

public:
	qt_listbox(QWidget *);

	virtual widget& set_attr(const std::string&, const std::string&);
	virtual std::string get_attr(const std::string& name);
	virtual QWidget *get_widget(void) const;
	virtual widget& insert(widget *);
};

class qt_vbox: public qt_widget
{
	QFrame *wnd;

public:
	qt_vbox(QWidget *);

	virtual widget& set_attr(const std::string&, const std::string&);
	virtual std::string get_attr(const std::string& name);
	virtual QWidget *get_widget(void) const;
	virtual widget& insert(widget *);
};

class qt_hbox: public qt_widget
{
	QFrame *wnd;

public:
	qt_hbox(QWidget *);

	virtual widget& set_attr(const std::string&, const std::string&);
	virtual std::string get_attr(const std::string& name);
	virtual QWidget *get_widget(void) const;
	virtual widget& insert(widget *);
};

#endif // DIALOG_QT_HH
