#include <look.hh>

bool look::view(const command& cmd)
{
	try
	{
		command newcmd;
		current_mapper()->map(cmd("id"), newcmd);
		newcmd.add(cmd, context::keepold);
		return perform(newcmd);
	}
	catch(const mapper::missing&)
	{
		command err(cmd);
		return error(err.name("/error/ctrl/look")
			     ("reason", "no such mapping"));
	}
	catch(const context::missing&)
	{
		command err(cmd);
		return error(err.name("/error/ctrl/look")
			     ("reason", "malformed command (id is missing)"));
	}
	return false;
}

bool look::attr(const command& cmd)
{
	try
	{
		widget *w = current_dialog()->who_is_it(cmd("ctrlid"));
		if(w) w->set_attr(cmd("field"), cmd("value"));
	}
	catch(const context::missing&)
	{
		command err(cmd);
		return error(err.name("/error/ctrl/look")
			     ("reason", "malformed command (id is missing)"));
	}
	return true;
}

bool look::perform(const command& cmd)
{
	if(cmd.name() == "/ctrl/look")
	{
		if(cmd("action") == "file") return file(cmd);
		else if(cmd("action") == "view") return view(cmd);
		else if(cmd("action") == "attr") return attr(cmd);
		else if(cmd("action") == "quit") return false;
		return true;
	}
	return send(cmd);
}
