#include <dialog-scm.hh>
#include <dialog-qt.hh>
#include <mapper.hh>
#include <command_io.hh>
#include <bus_io.hh>
#include <utils/str.hh>

#include <iostream>
#include <sstream>


#include <qapplication.h>

dialog *load_dialog(QMainWindow *wnd, const std::string& filename)
{
	dialog *d = new qt_dialog(wnd);
	call(scm::variable_ref("load-dialog"),
	     wrap_scm_dialog(d), scm::scm(filename));
	return d;
}

class look
{
	mapper *m_;
	QMainWindow *wnd_;
	dialog *dlg_;

public:
	look(const std::string& filename)
		: m_(new scm_mapper(filename)),
		  wnd_(new QMainWindow()),
		  dlg_(0)
	{
		wnd_->show();
	}

	~look(void)
	{
		delete m_;
		delete dlg_;
		delete wnd_;
	}

	command view(const command& cmd);
	void file(const command& cmd);
	void attr(const command& cmd);
	bool perform(const command& cmd);
	void run(const command& cmd);

private:
	bool perform_woo(const command& cmd);
	bool perform_cmds(scm::scm cmds);
};

void look::file(const command& cmd)
{
	dialog *newdlg = load_dialog(wnd_, cmd("name"));
	delete dlg_;
	dlg_ = newdlg;
}

command look::view(const command& cmd)
{
	try
	{
		command newcmd;
		m_->map(cmd("id"), newcmd);
		newcmd.add(cmd, context::keepold);
		return newcmd;
	}
	catch(const mapper::missing&)
	{
		std::cerr << "no such id: " << cmd("id") << std::endl;
	}
	return command("/ctrl/look")("action", "quit");
}

void look::attr(const command& cmd)
{
	try
	{
		widget *w = dlg_->who_is_it(cmd("ctrlid"));
		if(w) w->set_attr(cmd("field"), cmd("value"));
	}
	catch(...) //ignore command if some keys are missing
	{
	}
}

bool look::perform(const command& cmd)
{
	if(cmd.name() == "/ctrl/look")
	{
		if(cmd("action") == "file") file(cmd);
		else if(cmd("action") == "view") return perform(view(cmd));
		else if(cmd("action") == "attr") attr(cmd);
		else if(cmd("action") == "quit") return false;
		return true;
	}
	return perform_woo(cmd);
}

bool look::perform_woo(const command& cmd)
{
	// FIXME: hacks-hacks-hacks...
	// I need to rewrite bus_io.
	std::ostringstream devnull;
	std::ostringstream message;
	message << cmd;
	send(">>", message.str(), std::cin, std::cout, devnull);

	while(std::cin)
	{
		std::string addr;
		getline(std::cin, addr);
		if(addr == "<<")
		{
			std::istringstream is(receive(std::cin, std::cout,
								devnull));
			command cmd;
			while(is >> cmd)
			{
				if(alt::starts_with(cmd.name(), "/error"))
				{
					// FIXME: need a way to pass last error to handler
					if(!perform_cmds(call(scm::variable_ref("current-command-set-get"),
									scm::scm(dlg_->get_event("on-error")),
									wrap_scm_dialog(dlg_))))

						return false;
				}
			}
			break;
		}
		else std::cout << "<>" << std::endl;
	}
	return true;
}

void look::run(const command& start)
{
	if(!perform(start)) return;
	if(!dlg_)
	{
		std::cerr << "no dialog to work with" << std::endl;
		return;
	}


	long result;
	while((result = dlg_->run()) != 0)
	{
		if(!perform_cmds(call(scm::variable_ref(
					     "current-command-set-get"),
				     scm::scm(result),
				     wrap_scm_dialog(dlg_))))
			break;
	}
}

command& list_to_cmd(scm::scm, command&);

bool look::perform_cmds(scm::scm cmds)
{
	while(pair_p(cmds))
	{
		command cmd;
		if(!perform(list_to_cmd(car(cmds), cmd))) return false;
		cmds = cdr(cmds);
	}
	return true;
}

extern void init_scm_woo(void);
int main(int argc, char *argv[])
{
	QApplication a(argc, argv);
	scm::init();
	init_scm_dialog();
	init_scm_woo();
	scm::load("dialog.scm");
	scm::load("mapper.scm");

	a.connect(&a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()));

	look l("testmap.scm");
	l.run(command("/ctrl/look")("action", "view")("id", "/"));

	std::cout << "xx" << std::endl;
	return 0;
}
