#include <utils/guile.hh>
#include <utils/str.hh>
#include <command_io.hh>
#include <bus_io.hh>
#include <iostream>
#include <sstream>

SCM scm_woo_read(SCM name, SCM attr)
{
	scm::scm display = scm::variable_ref("display");
	std::ostringstream devnull;
	std::ostringstream message;
	message << command(scm::to_string(name, display).as_str())
				("action", "read");
	send(">>", message.str(), std::cin, std::cout, devnull);
	while(std::cin)
	{
		std::string addr;
		getline(std::cin, addr);
		if(addr == "<<")
		{
			std::istringstream is(receive(std::cin, std::cout,
								devnull));
			command cmd;
			is >> cmd;

			if(alt::starts_with(cmd.name(), "/error"))
			{
				// FIXME: how to call handler from here?
				// FIXME: need a way to pass last error to handler
			}
			else if(cmd.exists(scm::to_string(attr, display).as_str()))
				return scm::scm(cmd(scm::to_string(attr, display).as_str())).as_scm();
		}
		else std::cout << "<>" << std::endl;
	}
	return scm::scm("").as_scm();
}

SCM scm_woo_read_names(SCM name)
{
	scm::scm display = scm::variable_ref("display");
	std::ostringstream devnull;
	std::ostringstream message;
	message << command("/ctrl/cache")("action", "ignore");
	send(">>", message.str(), std::cin, std::cout, devnull);
	while(std::cin)
	{
		std::string address;
		getline(std::cin, address);
		if(address == "<<")
		{
			receive(std::cin, std::cout, devnull);
			break;
		}
		else std::cout << "<>" << std::endl;
	}

	scm::scm result(SCM_EOL);
	std::string prefix = scm::to_string(name, display).as_str();
	message.str("");
	message << command(prefix)("action", "read");
	send(">>", message.str(), std::cin, std::cout, devnull);
	while(std::cin)
	{
		std::string address;
		getline(std::cin, address);
		if(address == "<<")
		{
			std::istringstream is(receive(std::cin, std::cout, devnull));
			command cmd;
			while(is >> cmd)
			{
				if(alt::starts_with(cmd.name(), "/error"))
				{
				// FIXME: how to call handler from here?
				// FIXME: need a way to pass last error to handler
				}
				else if(alt::starts_with(cmd.name(), prefix))
				{
					result = scm::cons(scm::scm(cmd.name().substr(prefix.length() + 1)), result);
				}
			}
			break;
		}
		else std::cout << "<>" << std::endl;
	}
	return result.as_scm();
}

void init_scm_woo(void)
{
	scm_c_define_gsubr("woo-read", 2, 0, 0,
			   (SCM (*)())scm_woo_read);
	scm_c_define_gsubr("woo-read-names", 1, 0, 0,
			   (SCM (*)())scm_woo_read_names);
}
