#include <utils/guile.hh>
#include <command.hh>

struct convert_pair
{
	convert_pair(void): result_(SCM_EOL) {}

	void operator ()(const std::string& key, const std::string& value)
	{
		result_ = cons(cons(scm::scm(key), scm::scm(value)), result_);
	}

	operator scm::scm() const
	{
		return result_;
	}

private:
	scm::scm result_;
};

scm::scm cmd_to_list(const command& cmd)
{
	return cmd.for_each(convert_pair());
}
