;window definitions
width 640
height 480

;keyword definitions
(declare-keyword number)
(declare-keyword filename)
(declare-keyword passing)
(declare-keyword page)

;wizard specific events definitions
(declare-event on-next)
(declare-event on-prev)

;step definitions: will be included from config file
(define steps
  '(("Step 'A' of installer" "a.scm")
    ("Step 'B' of installer" "b.scm")
    ("Step 'C' of installer" "c.scm")))

;wizard helper functions
;local number as a number
(define (get-number) (string->number (global number)))

;passing mode
(define (global-passing?) (not (global filename)))

;work with steps
(define (current-step) (list-ref steps (get-number)))
(define (next-step) (+ (get-number) 1))
(define (prev-step) (- (get-number) 1))

;are we in final step
(define (last-step?) (= (- (length steps) 1) (get-number)))
;are we in the first step
(define (first-step?) (= 0 (get-number)))
;create top line with title
(define (title-line) (label (car (current-step))))

(define (step-line)
  (include (if (global-passing?)
	     (cadr (current-step))
	     (global filename))))

(define (prev-button)
  (if (global-passing?)
    (if (first-step?)
      (button "Cancel" (on-click look-quit))
      (button "Prev"
	      (on-click
		(look-view "/wizard" number (prev-step) passing 'global))))
    (button "Prev" (on-click (look-send page 'on-prev)))))

(define (next-button)
  (if (global-passing?)
    (if (last-step?)
      (button "Finish" (on-click look-quit))
      (button "Next"
	      (on-click
		(look-view "/wizard" number (next-step) passing 'global))))
    (button "Next" (on-click (look-send page 'on-next)))))

;create bottom line with buttons
(define (button-line)
  (hbox
    (prev-button)
    (next-button)))

;DEBUG
(format #t "filename is ~A~%" (global filename))
(format #t "number is ~A~%" (global number))
(format #t "passing type is ~A~%" (global passing))
(format #t "is global passing? ~A~%" (global-passing?))
(format #t "is this a last step? ~A~%" (last-step?))
(format #t "is this a first step? ~A~%" (first-step?))

(id page (vbox
	   (title-line)
	   (step-line)
	   (button-line)))

