#include <qtlook/dialog.hh>

#include <utils/shared_ptr.hh>

#include <command_set.hh>
#include <mapper.hh>

#include <iostream>

typedef alt::shared_ptr<qtlook::dialog> dialog_ptr;

/** load dialog from the xml description, also create appropriate command sets */
static void
look_file(const command& cmd, dialog_ptr& d, command_set& c)
{
	d = new qtlook::dialog();
	c = command_set();
	load_dialog(cmd("name"), *d.get(), c);
}

/** load url using mapper */
static command
look_view(const command& cmd, const mapper& m)
{
	try
	{
		return m.map(cmd("id"));
	} catch(const mapper::missing&)
	{
		std::cerr << "no such id: " << cmd("id") << std::endl;
	}
	return command("/ctrl/look")("action", "quit");
}

static void
look_attr(const command&, dialog_ptr&)
{
}

bool
process_cmd(const command& cmd, const mapper& m, dialog_ptr& d, command_set& c)
{
	std::cerr<<"processing command:"<<cmd.name()<<std::endl;

	if("/ctrl/look" == cmd.name())
	{
		if("file" == cmd("action"))
			look_file(cmd, d, c);
		else if("view" == cmd("action"))
			return process_cmd(look_view(cmd, m), m, d, c);
		else if("attr" == cmd("action"))
			look_attr(cmd, d);
		else if("quit" == cmd("action"))
			return false;
	}
	else
	{
		// send it to chooser
	}
	return true;
}
