;generalized read-script engine
(define (read-script filename valid-expr)
  (with-input-from-file filename
			(lambda ()
			  (let loop ((expr (read))
				     (result '()))
			    (if (eof-object? expr)
			      result
			      (cond
				((string? expr) (loop (read) result))
				((valid-expr expr) (loop (read) (append result (list expr))))
				(else (error "invalid config expression:" expr))))))))

;generalized print init info engine
(define (print-init lst)
  (for-each (lambda (x) (write-command (car x))) lst))

;general find and eval engine
(define (find-and-eval cmd lst match-proc made-proc)
  (let loop ((lst lst))
    (if (null? lst)
      #f
      (let* ((current (car lst))
	     (match-result (match-proc (car current) cmd)))
	(if match-result
	  (made-proc match-result cmd (cdr current))
	  (loop (cdr lst)))))))
